from flask_wtf import FlaskForm
from wtforms import StringField, TextAreaField, EmailField, SelectField, SubmitField
from wtforms.validators import DataRequired, Email, Length

class ContactForm(FlaskForm):
    name = StringField('Full Name', 
                      validators=[DataRequired(), Length(min=2, max=100)],
                      render_kw={
                          'aria-describedby': 'name-help',
                          'aria-required': 'true'
                      })
    
    email = EmailField('Email Address',
                      validators=[DataRequired(), Email()],
                      render_kw={
                          'aria-describedby': 'email-help',
                          'aria-required': 'true'
                      })
    
    subject = StringField('Subject',
                         validators=[DataRequired(), Length(min=5, max=200)],
                         render_kw={
                             'aria-describedby': 'subject-help',
                             'aria-required': 'true'
                         })
    
    message = TextAreaField('Message',
                           validators=[DataRequired(), Length(min=10, max=2000)],
                           render_kw={
                               'rows': 6,
                               'aria-describedby': 'message-help',
                               'aria-required': 'true'
                           })
    
    accessibility_needs = SelectField('Accessibility Requirements',
                                    choices=[
                                        ('', 'No specific requirements'),
                                        ('screen_reader', 'Screen reader user'),
                                        ('low_vision', 'Low vision/visual impairment'),
                                        ('hearing_impaired', 'Deaf or hard of hearing'),
                                        ('motor_impairment', 'Motor/mobility impairment'),
                                        ('cognitive', 'Cognitive accessibility needs'),
                                        ('multiple', 'Multiple accessibility needs'),
                                        ('other', 'Other (please specify in message)')
                                    ],
                                    render_kw={
                                        'aria-describedby': 'accessibility-help'
                                    })
    
    submit = SubmitField('Send Message')

class NewsletterForm(FlaskForm):
    email = EmailField('Email Address',
                      validators=[DataRequired(), Email()],
                      render_kw={
                          'placeholder': 'Enter your email for updates',
                          'aria-label': 'Email address for newsletter subscription'
                      })
    
    submit = SubmitField('Subscribe to Updates')
