# PrismaOS Website Deployment Guide for Aeon Free

## Overview
This guide will help you deploy the PrismaOS website to Aeon Free hosting with the domain prismaos.iceiy.com

## System Requirements
- **Hosting**: Aeon Free (web.aeonfree.com)
- **PHP Version**: 8.2
- **Database**: MySQL 8.0
- **Domain**: prismaos.iceiy.com

## Step 1: Prepare Your Files

### Download Required Files
1. Download all files from the `php-version` folder
2. Ensure you have these key files:
   - `index.php` (main application)
   - `.htaccess` (URL rewriting and security)
   - `config.php` (configuration)
   - `database.sql` (database setup)
   - All files in `/assets/` folder
   - All files in `/includes/` folder
   - All files in `/pages/` folder

## Step 2: Database Setup

### Create MySQL Database
1. Log into your Aeon Free control panel
2. Go to MySQL Databases section
3. Create a new database named `prismaos_db`
4. Create a database user with full privileges
5. Note down the database credentials:
   - Database Host: usually `localhost`
   - Database Name: `prismaos_db`
   - Username: (your created username)
   - Password: (your created password)

### Import Database Structure
1. In phpMyAdmin or MySQL interface
2. Select your `prismaos_db` database
3. Go to Import/SQL tab
4. Upload and execute the `database.sql` file

## Step 3: Configure the Application

### Update config.php
Edit the `config.php` file with your actual database credentials:

```php
define('DB_HOST', 'localhost'); // Your DB host
define('DB_NAME', 'prismaos_db'); // Your database name
define('DB_USER', 'your_username'); // Your DB username
define('DB_PASS', 'your_password'); // Your DB password
define('SITE_URL', 'https://prismaos.iceiy.com'); // Your domain
```

## Step 4: Upload Files

### File Upload via File Manager
1. Log into Aeon Free control panel
2. Open File Manager
3. Navigate to `public_html` or `www` folder
4. Upload all files from `php-version` folder
5. Maintain the folder structure:
   ```
   public_html/
   ├── index.php
   ├── .htaccess
   ├── config.php
   ├── database.sql
   ├── assets/
   │   ├── css/
   │   ├── js/
   │   └── images/
   ├── includes/
   │   ├── database.php
   │   ├── functions.php
   │   └── newsletter.php
   └── pages/
       ├── home.php
       ├── contact.php
       └── features.php
   ```

## Step 5: Domain Configuration

### Set Up prismaos.iceiy.com
1. In Aeon Free control panel, go to Domains section
2. Add `prismaos.iceiy.com` as an addon domain
3. Point it to your `public_html` folder
4. Wait for DNS propagation (may take 24-48 hours)

## Step 6: Test the Website

### Basic Functionality Test
1. Visit `https://prismaos.iceiy.com`
2. Check if the homepage loads correctly
3. Test navigation between pages
4. Verify that images and CSS are loading
5. Test the contact form submission
6. Try newsletter subscription

### Accessibility Features Test
1. Test font size adjustment buttons
2. Try high contrast mode toggle
3. Test text-to-speech demo (if browser supports it)
4. Verify keyboard navigation works
5. Check screen reader compatibility

## Step 7: Security Setup

### File Permissions
Set appropriate permissions for security:
- PHP files: 644
- Directories: 755
- config.php: 600 (more restrictive)

### SSL Certificate
1. Check if Aeon Free provides free SSL
2. If available, enable SSL for prismaos.iceiy.com
3. Force HTTPS in .htaccess (uncomment the redirect rules)

## Step 8: Ongoing Maintenance

### Regular Backups
1. Backup database regularly via phpMyAdmin
2. Download file backups periodically
3. Monitor contact form submissions

### Updates
1. Check contact submissions in database
2. Monitor newsletter subscriptions
3. Update content as needed

## Troubleshooting

### Common Issues

**Database Connection Error**
- Verify database credentials in config.php
- Check if database exists and user has permissions
- Ensure MySQL service is running

**Page Not Found (404)**
- Check if .htaccess file uploaded correctly
- Verify file permissions
- Ensure index.php is in root directory

**CSS/JS Not Loading**
- Check file paths in index.php
- Verify assets folder uploaded correctly
- Check .htaccess for any blocking rules

**Contact Form Not Working**
- Check database connection
- Verify contact_submissions table exists
- Check PHP error logs

### Getting Help
If you encounter issues:
1. Check Aeon Free documentation
2. Contact Aeon Free support
3. Review PHP error logs in control panel

## File Structure Summary

```
php-version/
├── index.php              # Main application file
├── config.php             # Configuration (update with your DB details)
├── .htaccess              # Security and URL rewriting
├── database.sql           # Database structure (import to MySQL)
├── DEPLOYMENT_GUIDE.md    # This guide
├── assets/
│   ├── css/
│   │   ├── main.css       # Main stylesheet
│   │   └── accessibility.css # Accessibility styles
│   ├── js/
│   │   ├── main.js        # Main JavaScript
│   │   └── accessibility.js # Accessibility features
│   └── images/
│       ├── prismaos-logo.png # Main logo
│       └── company-icon.png  # Company logo
├── includes/
│   ├── database.php       # Database connection class
│   ├── functions.php      # Helper functions
│   └── newsletter.php     # Newsletter handling
└── pages/
    ├── home.php          # Homepage content
    ├── contact.php       # Contact page with form
    └── features.php      # Features page
```

## Success Checklist

- [ ] Database created and configured
- [ ] All files uploaded with correct structure
- [ ] config.php updated with correct credentials
- [ ] Domain prismaos.iceiy.com configured
- [ ] Website loads at https://prismaos.iceiy.com
- [ ] All pages accessible via navigation
- [ ] Contact form works and saves to database
- [ ] Newsletter subscription works
- [ ] Accessibility features functional
- [ ] SSL certificate enabled (if available)

Your PrismaOS website should now be live at https://prismaos.iceiy.com!