<?php
session_start();

// Database configuration
$config = [
    'host' => 'localhost',
    'dbname' => 'prismaos_db',
    'username' => 'your_db_username',
    'password' => 'your_db_password'
];

// Include functions
include_once 'includes/functions.php';
include_once 'includes/database.php';

// Get current page
$page = $_GET['page'] ?? 'home';

// Page title
$page_titles = [
    'home' => 'PrismaOS - Accessible Mobile Operating System',
    'features' => 'Accessibility Features - PrismaOS',
    'technical' => 'Technical Documentation - PrismaOS',
    'sdk' => 'Developer SDK - PrismaOS',
    'community' => 'Community - PrismaOS',
    'roadmap' => 'Development Roadmap - PrismaOS',
    'contact' => 'Contact Us - PrismaOS'
];

$title = $page_titles[$page] ?? 'PrismaOS - Accessible Mobile Operating System';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($title); ?></title>
    
    <!-- SEO and Accessibility Meta Tags -->
    <meta name="description" content="PrismaOS is an innovative open-source mobile operating system built on Red Hat Linux, designed with exceptional accessibility features for users with disabilities.">
    <meta name="keywords" content="PrismaOS, accessible mobile OS, Red Hat Linux, accessibility, deaf, blind, mobile operating system">
    <meta name="author" content="PrismaOS Team">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome Icons -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Custom CSS -->
    <link href="assets/css/main.css" rel="stylesheet">
    <link href="assets/css/accessibility.css" rel="stylesheet">
    
    <!-- Prefers Reduced Motion Support -->
    <style>
        @media (prefers-reduced-motion: reduce) {
            *, *::before, *::after {
                animation-duration: 0.01ms !important;
                animation-iteration-count: 1 !important;
                transition-duration: 0.01ms !important;
            }
        }
    </style>
</head>
<body>
    <!-- Skip Navigation Links -->
    <div class="skip-links">
        <a href="#main-content" class="skip-link">Skip to main content</a>
        <a href="#navigation" class="skip-link">Skip to navigation</a>
        <a href="#footer" class="skip-link">Skip to footer</a>
    </div>

    <!-- Accessibility Toolbar -->
    <div id="accessibility-toolbar" class="accessibility-toolbar" role="toolbar" aria-label="Accessibility Options">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-auto">
                    <span class="toolbar-label">Accessibility:</span>
                </div>
                <div class="col-auto">
                    <button type="button" class="btn btn-sm btn-outline-primary" id="increase-font" aria-label="Increase font size">
                        <i class="fas fa-plus" aria-hidden="true"></i> Font
                    </button>
                </div>
                <div class="col-auto">
                    <button type="button" class="btn btn-sm btn-outline-primary" id="decrease-font" aria-label="Decrease font size">
                        <i class="fas fa-minus" aria-hidden="true"></i> Font
                    </button>
                </div>
                <div class="col-auto">
                    <button type="button" class="btn btn-sm btn-outline-primary" id="high-contrast" aria-label="Toggle high contrast mode">
                        <i class="fas fa-adjust" aria-hidden="true"></i> Contrast
                    </button>
                </div>
                <div class="col-auto">
                    <button type="button" class="btn btn-sm btn-outline-primary" id="reduce-motion" aria-label="Reduce motion and animations">
                        <i class="fas fa-pause" aria-hidden="true"></i> Motion
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Navigation -->
    <header>
        <nav id="navigation" class="navbar navbar-expand-lg navbar-dark bg-primary" role="navigation" aria-label="Main navigation">
            <div class="container">
                <a class="navbar-brand d-flex align-items-center" href="index.php" aria-label="PrismaOS Home">
                    <img src="assets/images/prismaos-logo.png" alt="PrismaOS Logo" class="brand-logo me-2">
                    <span class="brand-text">PrismaOS</span>
                </a>
                
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" 
                        aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                
                <div class="collapse navbar-collapse" id="navbarNav">
                    <ul class="navbar-nav ms-auto">
                        <li class="nav-item">
                            <a class="nav-link <?php echo $page === 'home' ? 'active' : ''; ?>" href="index.php">Home</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $page === 'features' ? 'active' : ''; ?>" href="?page=features">Features</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $page === 'technical' ? 'active' : ''; ?>" href="?page=technical">Technical</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $page === 'sdk' ? 'active' : ''; ?>" href="?page=sdk">SDK</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $page === 'community' ? 'active' : ''; ?>" href="?page=community">Community</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $page === 'roadmap' ? 'active' : ''; ?>" href="?page=roadmap">Roadmap</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $page === 'contact' ? 'active' : ''; ?>" href="?page=contact">Contact</a>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>
    </header>

    <!-- Main Content -->
    <main id="main-content" role="main">
        <?php
        // Include the appropriate page content
        switch ($page) {
            case 'features':
                include 'pages/features.php';
                break;
            case 'technical':
                include 'pages/technical.php';
                break;
            case 'sdk':
                include 'pages/sdk.php';
                break;
            case 'community':
                include 'pages/community.php';
                break;
            case 'roadmap':
                include 'pages/roadmap.php';
                break;
            case 'contact':
                include 'pages/contact.php';
                break;
            default:
                include 'pages/home.php';
                break;
        }
        ?>
    </main>

    <!-- Flash Messages -->
    <?php if (isset($_SESSION['flash_message'])): ?>
    <div class="alert alert-<?php echo $_SESSION['flash_type'] ?? 'info'; ?> alert-dismissible fade show" role="alert">
        <?php echo htmlspecialchars($_SESSION['flash_message']); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php 
        unset($_SESSION['flash_message'], $_SESSION['flash_type']);
    endif; 
    ?>

    <!-- Footer -->
    <footer id="footer" class="bg-dark text-light py-5 mt-5">
        <div class="container">
            <div class="row">
                <div class="col-md-4">
                    <h5>PrismaOS</h5>
                    <p>An accessible Red Hat-based mobile operating system designed for everyone.</p>
                    <div class="social-links">
                        <a href="https://www.linkedin.com/company/prismaos" class="text-light me-3" aria-label="Follow PrismaOS on LinkedIn" target="_blank" rel="noopener noreferrer">
                            <i class="fab fa-linkedin" aria-hidden="true"></i>
                        </a>
                        <a href="https://www.youtube.com/@prismaos" class="text-light me-3" aria-label="Subscribe to PrismaOS on YouTube" target="_blank" rel="noopener noreferrer">
                            <i class="fab fa-youtube" aria-hidden="true"></i>
                        </a>
                        <a href="https://www.threads.com/@prisma.os" class="text-light me-3" aria-label="Follow PrismaOS on Threads" target="_blank" rel="noopener noreferrer">
                            <i class="fab fa-threads" aria-hidden="true"></i>
                        </a>
                        <a href="https://www.instagram.com/prisma.os" class="text-light" aria-label="Follow PrismaOS on Instagram" target="_blank" rel="noopener noreferrer">
                            <i class="fab fa-instagram" aria-hidden="true"></i>
                        </a>
                    </div>
                </div>
                <div class="col-md-4">
                    <h5>Quick Links</h5>
                    <ul class="list-unstyled">
                        <li><a href="?page=features" class="text-light">Accessibility Features</a></li>
                        <li><a href="?page=technical" class="text-light">Technical Documentation</a></li>
                        <li><a href="?page=sdk" class="text-light">Developer SDK</a></li>
                        <li><a href="?page=roadmap" class="text-light">Development Roadmap</a></li>
                    </ul>
                </div>
                <div class="col-md-4">
                    <h5>Stay Updated</h5>
                    <p>Subscribe to receive updates about PrismaOS development.</p>
                    <form method="POST" action="includes/newsletter.php" class="newsletter-form">
                        <div class="input-group">
                            <input type="email" class="form-control" name="email" placeholder="Enter your email" 
                                   aria-label="Email address for newsletter subscription" required>
                            <button class="btn btn-primary" type="submit" aria-label="Subscribe to newsletter">
                                <i class="fas fa-paper-plane" aria-hidden="true"></i>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            <hr class="my-4">
            <!-- Company Branding -->
            <div class="row align-items-center mb-3">
                <div class="col-12 text-center">
                    <div class="company-branding d-flex align-items-center justify-content-center">
                        <img src="assets/images/company-icon.png" 
                             alt="PT.IDE KREATIF SEJAHTERA GLOBAL" 
                             class="company-icon me-3">
                        <div class="company-info">
                            <p class="mb-0 fw-bold text-light">Powered by PT.IDE KREATIF SEJAHTERA GLOBAL</p>
                            <p class="mb-0 text-muted small">Innovation through Creative Global Solutions</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row align-items-center">
                <div class="col-md-6">
                    <p class="mb-0">&copy; 2025 PrismaOS. Open source under MIT License.</p>
                </div>
                <div class="col-md-6 text-md-end">
                    <a href="#" class="text-light me-3">Privacy Policy</a>
                    <a href="#" class="text-light me-3">Terms of Service</a>
                    <a href="?page=contact" class="text-light">Accessibility Statement</a>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Custom JavaScript -->
    <script src="assets/js/accessibility.js"></script>
    <script src="assets/js/main.js"></script>
</body>
</html>