<section class="features-hero py-5 bg-primary text-white">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center">
                <h1 class="display-4 fw-bold mb-4">Accessibility Features</h1>
                <p class="lead">Comprehensive accessibility tools designed for users with diverse needs</p>
            </div>
        </div>
    </div>
</section>

<section class="features-detail py-5">
    <div class="container">
        <div class="row g-5">
            <?php foreach (get_accessibility_features() as $index => $feature): ?>
            <div class="col-lg-6">
                <div class="feature-detail-card h-100 p-4 border rounded-3">
                    <div class="feature-header d-flex align-items-center mb-4">
                        <div class="feature-icon me-3">
                            <i class="<?php echo $feature['icon']; ?> fa-3x text-primary" aria-hidden="true"></i>
                        </div>
                        <h2 class="h3 fw-bold mb-0"><?php echo htmlspecialchars($feature['title']); ?></h2>
                    </div>
                    <p class="lead mb-4"><?php echo htmlspecialchars($feature['description']); ?></p>
                    
                    <?php if ($index === 0): // Deaf Users ?>
                    <ul class="feature-list">
                        <li><i class="fas fa-check text-success me-2"></i>Real-time closed captioning for all audio</li>
                        <li><i class="fas fa-check text-success me-2"></i>Visual notification system with customizable alerts</li>
                        <li><i class="fas fa-check text-success me-2"></i>Sign language recognition for camera input</li>
                        <li><i class="fas fa-check text-success me-2"></i>Haptic feedback patterns for different events</li>
                        <li><i class="fas fa-check text-success me-2"></i>Text-based communication prioritization</li>
                    </ul>
                    <?php elseif ($index === 1): // Blind Users ?>
                    <ul class="feature-list">
                        <li><i class="fas fa-check text-success me-2"></i>Advanced screen reader with natural voice synthesis</li>
                        <li><i class="fas fa-check text-success me-2"></i>Comprehensive voice command navigation</li>
                        <li><i class="fas fa-check text-success me-2"></i>Audio descriptions for visual content</li>
                        <li><i class="fas fa-check text-success me-2"></i>Optimized gesture controls for touch navigation</li>
                        <li><i class="fas fa-check text-success me-2"></i>Braille display support and integration</li>
                    </ul>
                    <?php elseif ($index === 2): // Motor Accessibility ?>
                    <ul class="feature-list">
                        <li><i class="fas fa-check text-success me-2"></i>Customizable gesture and touch sensitivity</li>
                        <li><i class="fas fa-check text-success me-2"></i>Voice navigation for hands-free control</li>
                        <li><i class="fas fa-check text-success me-2"></i>Switch control support for external devices</li>
                        <li><i class="fas fa-check text-success me-2"></i>Adaptive touch interfaces with larger targets</li>
                        <li><i class="fas fa-check text-success me-2"></i>Eye tracking compatibility for gaze control</li>
                    </ul>
                    <?php else: // Cognitive Support ?>
                    <ul class="feature-list">
                        <li><i class="fas fa-check text-success me-2"></i>Simplified user interfaces with clear navigation</li>
                        <li><i class="fas fa-check text-success me-2"></i>Memory aids and reminder systems</li>
                        <li><i class="fas fa-check text-success me-2"></i>Focus assistance and distraction reduction</li>
                        <li><i class="fas fa-check text-success me-2"></i>Customizable complexity levels</li>
                        <li><i class="fas fa-check text-success me-2"></i>Step-by-step guided interactions</li>
                    </ul>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- Interactive Demos Section -->
<section class="demos-section py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h2 class="display-5 fw-bold">Try Our Accessibility Features</h2>
                <p class="lead text-muted">Experience how PrismaOS makes technology accessible to everyone</p>
            </div>
        </div>
        
        <div class="row g-4">
            <!-- Text-to-Speech Demo -->
            <div class="col-md-6 col-lg-4">
                <div class="demo-card p-4 bg-white border rounded-3 h-100">
                    <h3 class="h5 mb-3">
                        <i class="fas fa-volume-up text-primary me-2"></i>
                        Text-to-Speech
                    </h3>
                    <p class="mb-3">Natural voice synthesis for screen reading</p>
                    <div class="demo-controls">
                        <button class="btn btn-primary btn-sm" onclick="demoTextToSpeech()">
                            <i class="fas fa-play me-1"></i> Try Demo
                        </button>
                    </div>
                </div>
            </div>
            
            <!-- High Contrast Demo -->
            <div class="col-md-6 col-lg-4">
                <div class="demo-card p-4 bg-white border rounded-3 h-100">
                    <h3 class="h5 mb-3">
                        <i class="fas fa-adjust text-primary me-2"></i>
                        High Contrast
                    </h3>
                    <p class="mb-3">Enhanced visibility for low vision users</p>
                    <div class="demo-controls">
                        <button class="btn btn-primary btn-sm" onclick="toggleHighContrastDemo()">
                            <i class="fas fa-eye me-1"></i> Toggle Demo
                        </button>
                    </div>
                </div>
            </div>
            
            <!-- Voice Commands Demo -->
            <div class="col-md-6 col-lg-4">
                <div class="demo-card p-4 bg-white border rounded-3 h-100">
                    <h3 class="h5 mb-3">
                        <i class="fas fa-microphone text-primary me-2"></i>
                        Voice Commands
                    </h3>
                    <p class="mb-3">Hands-free navigation and control</p>
                    <div class="demo-controls">
                        <button class="btn btn-primary btn-sm" onclick="demoVoiceCommands()">
                            <i class="fas fa-microphone me-1"></i> Try Demo
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
function demoTextToSpeech() {
    const text = "PrismaOS provides advanced text-to-speech capabilities with natural voice synthesis, making digital content accessible to users with visual impairments.";
    if ('speechSynthesis' in window) {
        const utterance = new SpeechSynthesisUtterance(text);
        utterance.rate = 0.8;
        speechSynthesis.speak(utterance);
    } else {
        alert('Text-to-speech is not supported in your browser.');
    }
}

function toggleHighContrastDemo() {
    document.body.classList.toggle('high-contrast-demo');
    const button = event.target.closest('button');
    if (document.body.classList.contains('high-contrast-demo')) {
        button.innerHTML = '<i class="fas fa-eye me-1"></i> Normal View';
    } else {
        button.innerHTML = '<i class="fas fa-eye me-1"></i> Toggle Demo';
    }
}

function demoVoiceCommands() {
    alert('Voice command demo: Say "increase font size", "high contrast", or "read page" to control PrismaOS features.');
}
</script>

<style>
.high-contrast-demo {
    background-color: #000000 !important;
    color: #ffffff !important;
}
.high-contrast-demo .bg-white {
    background-color: #000000 !important;
    color: #ffffff !important;
    border-color: #ffffff !important;
}
.high-contrast-demo .text-primary {
    color: #ffff00 !important;
}
</style>