<!-- Hero Section -->
<section class="hero-section bg-primary text-white py-5" role="banner">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <h1 class="display-4 fw-bold mb-4">
                    PrismaOS
                    <span class="text-warning">Accessible</span> Mobile OS
                </h1>
                <p class="lead mb-4">
                    An innovative open-source mobile operating system built on Red Hat Linux foundations, 
                    designed specifically to provide exceptional accessibility features for users with disabilities.
                </p>
                <div class="hero-actions">
                    <a href="?page=features" class="btn btn-warning btn-lg me-3">
                        <i class="fas fa-universal-access" aria-hidden="true"></i>
                        Explore Features
                    </a>
                    <a href="?page=technical" class="btn btn-outline-light btn-lg">
                        <i class="fas fa-download" aria-hidden="true"></i>
                        Technical Docs
                    </a>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="hero-image text-center">
                    <!-- SVG illustration of mobile device with accessibility symbols -->
                    <svg width="400" height="300" viewBox="0 0 400 300" xmlns="http://www.w3.org/2000/svg" role="img" aria-labelledby="hero-illustration-title">
                        <title id="hero-illustration-title">PrismaOS mobile device with accessibility features</title>
                        <!-- Mobile device outline -->
                        <rect x="140" y="40" width="120" height="220" rx="20" fill="#ffffff" stroke="#333" stroke-width="2"/>
                        <!-- Screen -->
                        <rect x="150" y="60" width="100" height="180" rx="10" fill="#e9ecef"/>
                        <!-- Accessibility symbols -->
                        <circle cx="200" cy="120" r="15" fill="#ffc107"/>
                        <text x="200" y="125" text-anchor="middle" fill="#212529" font-size="12" font-family="Arial">♿</text>
                        <!-- Signal waves for audio -->
                        <path d="M120 140 Q130 130 140 140 Q130 150 120 140" stroke="#28a745" stroke-width="2" fill="none"/>
                        <path d="M260 140 Q270 130 280 140 Q270 150 260 140" stroke="#28a745" stroke-width="2" fill="none"/>
                        <!-- Voice/sound indicators -->
                        <circle cx="100" cy="140" r="3" fill="#17a2b8"/>
                        <circle cx="300" cy="140" r="3" fill="#17a2b8"/>
                    </svg>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- PrismaOS Brand Banner -->
<section class="brand-banner py-4 bg-light" role="banner">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-12 text-center">
                <div class="brand-showcase d-flex align-items-center justify-content-center">
                    <img src="assets/images/prismaos-logo.png" 
                         alt="PrismaOS - Built on Linux Open Source Foundation" 
                         class="brand-banner-logo">
                    <div class="brand-info ms-4">
                        <p class="mb-1 text-muted small">Powered by</p>
                        <p class="mb-0 fw-bold text-primary">Linux Open Source Foundation</p>
                        <p class="mb-0 text-muted small">Red Hat Enterprise Architecture</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Key Features Overview -->
<section class="features-overview py-5" id="overview">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h2 class="display-5 fw-bold">Accessibility First Design</h2>
                <p class="lead text-muted">PrismaOS is built from the ground up with accessibility as a core principle, not an afterthought.</p>
            </div>
        </div>
        <div class="row g-4">
            <?php foreach (get_accessibility_features() as $feature): ?>
            <div class="col-md-6 col-lg-3">
                <div class="feature-card h-100 text-center p-4 border rounded-3">
                    <div class="feature-icon mb-3">
                        <i class="<?php echo $feature['icon']; ?> fa-3x text-primary" aria-hidden="true"></i>
                    </div>
                    <h3 class="h5 fw-bold"><?php echo htmlspecialchars($feature['title']); ?></h3>
                    <p class="text-muted"><?php echo htmlspecialchars($feature['description']); ?></p>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- Demo Section -->
<section class="demo-section py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h2 class="display-5 fw-bold">Experience PrismaOS</h2>
                <p class="lead text-muted">Try out some of the accessibility features that make PrismaOS special.</p>
            </div>
        </div>
        <div class="row g-4">
            <div class="col-md-6">
                <div class="demo-card p-4 bg-white border rounded-3 h-100">
                    <h3 class="h4 mb-3">
                        <i class="fas fa-volume-up text-primary me-2" aria-hidden="true"></i>
                        Text-to-Speech Demo
                    </h3>
                    <p class="mb-3">Experience PrismaOS's advanced text-to-speech capabilities with natural voice synthesis.</p>
                    <div class="demo-area">
                        <textarea class="form-control mb-3" id="tts-text" rows="3" 
                                  placeholder="Enter text to hear it spoken...">Welcome to PrismaOS, the accessible mobile operating system designed for everyone.</textarea>
                        <div class="demo-controls">
                            <button class="btn btn-primary me-2" id="speak-btn" onclick="speakText()">
                                <i class="fas fa-play" aria-hidden="true"></i> Speak
                            </button>
                            <button class="btn btn-secondary" id="stop-btn" onclick="stopSpeaking()">
                                <i class="fas fa-stop" aria-hidden="true"></i> Stop
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="demo-card p-4 bg-white border rounded-3 h-100">
                    <h3 class="h4 mb-3">
                        <i class="fas fa-microphone text-primary me-2" aria-hidden="true"></i>
                        Voice Commands Demo
                    </h3>
                    <p class="mb-3">Try voice commands to control PrismaOS features hands-free.</p>
                    <div class="demo-area">
                        <div class="voice-status mb-3 p-3 bg-light rounded">
                            <div id="voice-status">Click "Start Listening" and say a command</div>
                        </div>
                        <div class="demo-controls">
                            <button class="btn btn-primary me-2" id="listen-btn" onclick="startListening()">
                                <i class="fas fa-microphone" aria-hidden="true"></i> Start Listening
                            </button>
                            <button class="btn btn-secondary" id="stop-listen-btn" onclick="stopListening()">
                                <i class="fas fa-microphone-slash" aria-hidden="true"></i> Stop
                            </button>
                        </div>
                        <div class="mt-3">
                            <small class="text-muted">Try commands: "increase font size", "high contrast", "read page"</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Statistics Section -->
<section class="stats-section py-5">
    <div class="container">
        <div class="row text-center">
            <div class="col-md-3 mb-4">
                <div class="stat-item">
                    <div class="stat-number display-4 fw-bold text-primary">1.3B</div>
                    <div class="stat-label">People with disabilities worldwide</div>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="stat-item">
                    <div class="stat-number display-4 fw-bold text-primary">98%</div>
                    <div class="stat-label">Websites lack accessibility features</div>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="stat-item">
                    <div class="stat-number display-4 fw-bold text-primary">15%</div>
                    <div class="stat-label">Of global population has some form of disability</div>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="stat-item">
                    <div class="stat-number display-4 fw-bold text-primary">100%</div>
                    <div class="stat-label">Accessible design benefits everyone</div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Call to Action -->
<section class="cta-section py-5 bg-primary text-white">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8">
                <h2 class="display-5 fw-bold mb-3">Ready to Experience True Accessibility?</h2>
                <p class="lead mb-0">Join our community and help shape the future of accessible mobile technology.</p>
            </div>
            <div class="col-lg-4 text-lg-end">
                <a href="?page=community" class="btn btn-warning btn-lg me-3">
                    <i class="fas fa-users" aria-hidden="true"></i>
                    Join Community
                </a>
                <a href="?page=contact" class="btn btn-outline-light btn-lg">
                    <i class="fas fa-envelope" aria-hidden="true"></i>
                    Get in Touch
                </a>
            </div>
        </div>
    </div>
</section>

<script>
// Text-to-Speech Demo
function speakText() {
    const text = document.getElementById('tts-text').value;
    if ('speechSynthesis' in window) {
        const utterance = new SpeechSynthesisUtterance(text);
        utterance.rate = 0.8;
        utterance.pitch = 1;
        speechSynthesis.speak(utterance);
    } else {
        alert('Text-to-speech is not supported in your browser.');
    }
}

function stopSpeaking() {
    if ('speechSynthesis' in window) {
        speechSynthesis.cancel();
    }
}

// Voice Recognition Demo
let recognition;

function startListening() {
    if ('webkitSpeechRecognition' in window || 'SpeechRecognition' in window) {
        const SpeechRecognition = window.SpeechRecognition || window.webkitSpeechRecognition;
        recognition = new SpeechRecognition();
        recognition.continuous = true;
        recognition.interimResults = true;
        recognition.lang = 'en-US';

        recognition.onstart = function() {
            document.getElementById('voice-status').textContent = 'Listening... Speak now!';
        };

        recognition.onresult = function(event) {
            let transcript = '';
            for (let i = event.resultIndex; i < event.results.length; i++) {
                transcript += event.results[i][0].transcript;
            }
            document.getElementById('voice-status').textContent = 'You said: ' + transcript;
            
            // Process voice commands
            processVoiceCommand(transcript.toLowerCase());
        };

        recognition.onerror = function(event) {
            document.getElementById('voice-status').textContent = 'Error: ' + event.error;
        };

        recognition.start();
    } else {
        alert('Speech recognition is not supported in your browser.');
    }
}

function stopListening() {
    if (recognition) {
        recognition.stop();
        document.getElementById('voice-status').textContent = 'Stopped listening.';
    }
}

function processVoiceCommand(command) {
    if (command.includes('increase font') || command.includes('bigger font')) {
        document.getElementById('voice-status').textContent = 'Command recognized: Increasing font size';
        // Simulate font size increase
    } else if (command.includes('high contrast')) {
        document.getElementById('voice-status').textContent = 'Command recognized: Toggling high contrast';
        // Simulate high contrast toggle
    } else if (command.includes('read page')) {
        document.getElementById('voice-status').textContent = 'Command recognized: Reading page content';
        // Simulate page reading
    }
}
</script>