# PrismaOS Website - Replit Configuration

## Overview

This is a Flask-based website for PrismaOS, an accessible mobile operating system built on Red Hat Linux. The website serves as a comprehensive information portal showcasing the features, technical documentation, developer resources, and community aspects of PrismaOS. The primary focus is on accessibility and inclusive design, making information about this accessible mobile OS available to all users.

## System Architecture

### Backend Architecture
- **Framework**: Flask (Python web framework)
- **Database**: SQLAlchemy ORM with SQLite (default) or PostgreSQL support via environment variables
- **Form Handling**: Flask-WTF for secure form processing with CSRF protection
- **Email**: Flask-Mail configuration for contact form submissions
- **Session Management**: Flask sessions with configurable secret keys

### Frontend Architecture
- **Template Engine**: Jinja2 (Flask's default templating)
- **CSS Framework**: Bootstrap 5.3.0 for responsive design
- **Icons**: Font Awesome 6.4.0 for accessibility and UI icons
- **Accessibility**: Custom CSS and JavaScript for enhanced accessibility features
- **Progressive Enhancement**: JavaScript features that enhance but don't break basic functionality

### Database Schema
- **ContactSubmission**: Stores contact form submissions with accessibility needs tracking
- **NewsletterSubscription**: Manages email subscriptions (referenced but form implementation pending)

## Key Components

### Core Application (`app.py`)
- Flask application factory pattern
- Database configuration with connection pooling
- Mail server configuration for contact forms
- ProxyFix middleware for deployment behind reverse proxies
- Automatic table creation on startup

### Models (`models.py`)
- ContactSubmission: Tracks user inquiries with accessibility requirements
- NewsletterSubscription: Email subscription management
- Timestamp tracking for all submissions

### Forms (`forms.py`)
- ContactForm: Comprehensive contact form with accessibility needs selector
- CSRF protection and input validation
- Accessibility-focused form rendering with ARIA attributes

### Routes (`routes.py`)
- Static pages: index, features, technical, sdk, community, roadmap
- Contact form handling with database persistence
- Error handling and user feedback via flash messages

### Templates
- **Base template**: Accessible HTML5 structure with skip links, ARIA landmarks
- **Accessibility toolbar**: Font size controls, high contrast mode, motion reduction
- **Responsive design**: Mobile-first approach with Bootstrap grid system
- **Semantic HTML**: Proper heading hierarchy and landmark roles

### Static Assets
- **Accessibility CSS**: High contrast mode, focus management, motion reduction
- **Main CSS**: Custom styling with CSS variables for consistency
- **Accessibility JS**: Font size adjustment, contrast toggling, keyboard navigation
- **Main JS**: Interactive demos, smooth scrolling, form enhancements

## Data Flow

### Contact Form Submission
1. User fills out contact form with accessibility needs specification
2. Flask-WTF validates form data with CSRF protection
3. ContactSubmission model saves data to database
4. Email notification sent to appropriate team (general or accessibility)
5. User receives confirmation message via flash system

### Accessibility Features
1. User activates accessibility toolbar controls
2. JavaScript applies real-time changes (font size, contrast, motion)
3. Settings persist in browser localStorage
4. Screen reader announcements for important changes

## External Dependencies

### Python Packages
- Flask: Web framework
- Flask-SQLAlchemy: Database ORM
- Flask-WTF: Form handling and CSRF protection
- Flask-Mail: Email functionality
- Werkzeug: WSGI utilities including ProxyFix

### Frontend Dependencies (CDN)
- Bootstrap 5.3.0: UI framework
- Font Awesome 6.4.0: Icon library

### Development Tools
- SQLite: Default development database
- Environment variables for production configuration

## Deployment Strategy

### Environment Configuration
- **SESSION_SECRET**: Flask session encryption key
- **DATABASE_URL**: Database connection string (SQLite default, PostgreSQL supported)
- **MAIL_SERVER/PORT/USERNAME/PASSWORD**: Email server configuration
- **MAIL_USE_TLS**: Email encryption settings

### Production Considerations
- ProxyFix middleware configured for reverse proxy deployment
- Database connection pooling with health checks
- Configurable mail settings for contact form functionality
- Debug mode disabled in production

### Accessibility Compliance
- WCAG 2.1 AA compliance targeted
- Screen reader compatibility testing
- Keyboard navigation support
- High contrast and motion reduction features
- Skip links and proper ARIA labeling

## Changelog
- July 01, 2025: Added PT.IDE KREATIF SEJAHTERA GLOBAL company branding in footer section
- July 01, 2025: Updated social media links (LinkedIn, YouTube, Threads, Instagram)
- July 01, 2025: Added PrismaOS brand banner with Linux open source foundation branding
- July 01, 2025: Initial setup

## User Preferences

Preferred communication style: Simple, everyday language.